package com.swvoyages.reservation;

import java.util.Hashtable;

/*
* L'interface <code>ReservationRegistry</code> dfinit le registre 
* de toutes les rservations en cours dans le processus d'excution 
* courant (application).
*
* @version  1.0
*/
public interface ReservationRegistry {

	/*
	* Purge le registre des rservations.
	*/
	public void clear();

	/*
	* Renvoie la table des rservations en cours (clone).
	*
	* @return		Hashtable la table des rservations en cours
	*/
	public Hashtable getAllReservations();

	/*
	* Renvoie la rservation correspondant  l'identifiant pass en
	* paramtre, si elle existe dans le registre, <b>null</b> sinon.
	*
	* @param		reservationId l'identifiant de la rservation
	*
	* @return		Object la rservation rfrence par l'identifiant 
	*				reservationId; <b>null</b> sinon
	*/
	public Object getReservation(Object reservationId);

	/*
	* Initialise le registre des rservations.
	*/
	public void initialize();

	/*
	* Renvoie <b>true</b> si le registre rfrence des rservations
	* en cours.
	*
	* @return		<code>true</code> si le registre contient des
	*				rservations; <code>false</code> sinon
	*/
	public boolean isEmpty();

	/*
	* Renvoie <b>true</b> si la rservation passe en paramtre
	* est enregistre.
	*
	* @param		reservation la rservation  vrifier
	*
	* @return		<code>true</code> si la rservation est
	*				enregistre; <code>false</code> sinon
	*/
	public boolean isReservationRegistered(Object reservation);

	/*
	* Enregistre une nouvelle rservation.
	*
	* @param		reservationId l'identifiant de la rservation 
	* @param		reservation la rservation
	*
	* @return		Object la nouvelle rservation enregistre
	*
	* @throws		ReservationException lance si une anomalie se
	*				produit durant l'enregistrement de la rservation
	*/
	public Object newReservation(Object reservationId, Object reservation) 
		throws ReservationException;

	/*
	* Libre les rservations du registre.
	*/
	public void release();

	/*
	* Supprime la rservation identifie du registre.
	*
	* @param		reservationId l'identifiant de la rservation
	*/
	public void removeReservation(Object reservationId);

	/*
	* Renvoie le nombre des rservations en cours.
	*
	* @return		int le nombre des rservations en cours
	*/
	public int size();
}